/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import de.darmstadt.tu.crossing.ui.wizard.CrySLDrillDownComposite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class CrySLTreeViewer
extends TreeViewer {
    public CrySLTreeViewer(CrySLDrillDownComposite drillDown, int none) {
        super((Composite)drillDown, none);
    }

    protected void internalInitializeTree(Control tree) {
        this.createChildren((Widget)tree);
        this.internalExpandToLevel((Widget)tree, 0);
    }

    protected void createChildren(Widget widget) {
        this.createChild(widget, true);
    }

    protected void internalExpandToLevel(Widget widget, int level) {
        if (level == -1 || level > 0) {
            Item[] children;
            if (widget instanceof Item && widget.getData() != null && !this.isExpandable((Item)widget, null, widget.getData())) {
                return;
            }
            this.createChild(widget, false);
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, true);
            }
            if ((level == -1 || level > 1) && (children = this.getChildren(widget)) != null) {
                int newLevel = level == -1 ? -1 : level - 1;
                Item[] itemArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Item element = itemArray[n2];
                    this.internalExpandToLevel((Widget)element, newLevel);
                    ++n2;
                }
            }
        }
    }

    void createChild(Widget widget, boolean materialize) {
        boolean oldBusy = this.isBusy();
        this.setBusy(true);
        try {
            Object d;
            Object data;
            Item[] items = this.getChildren(widget);
            if (items != null && items.length > 0 && (data = items[0].getData()) != null) {
                return;
            }
            if (items != null) {
                Item[] itemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    if (item.getData() != null) {
                        this.disassociate(item);
                        Assert.isTrue((item.getData() == null ? 1 : 0) != 0, (String)"Second or later child is non -null");
                    }
                    item.dispose();
                    ++n2;
                }
            }
            if ((d = widget.getData()) != null) {
                Object[] children;
                Object parentElement = d;
                if (this.isTreePathContentProvider() && widget instanceof Item) {
                    TreePath path = this.getTreePathFromItem((Item)widget);
                    children = this.getSortedChildren(path);
                } else {
                    children = this.getSortedChildren(parentElement);
                }
                Object[] objectArray = children;
                int n = children.length;
                int n3 = 0;
                while (n3 < n) {
                    Object element = objectArray[n3];
                    if (d.equals(this.getRoot())) {
                        this.createTreeItem(widget, element, -1);
                    } else {
                        IFolder iFolder = (IFolder)element;
                        if (iFolder.getName().equals("src")) {
                            this.createTreeItem(widget, element, -1);
                        }
                    }
                    ++n3;
                }
            }
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    private boolean isExpandable(Item item, TreePath parentPath, Object element) {
        Object elementOrTreePath = element;
        if (this.isTreePathContentProvider()) {
            elementOrTreePath = parentPath != null ? parentPath.createChildPath(element) : this.getTreePathFromItem(item);
        }
        return this.isExpandable(elementOrTreePath);
    }

    private boolean isTreePathContentProvider() {
        return this.getContentProvider() instanceof ITreePathContentProvider;
    }
}

