/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import de.darmstadt.tu.crossing.ui.utils.ClassPathLoader;
import de.darmstadt.tu.crossing.ui.wizard.CrySLComposite;
import de.darmstadt.tu.crossing.ui.wizard.CrySLContainerSelectionDialog;
import de.darmstadt.tu.crossing.ui.wizard.CrySLFile;
import de.darmstadt.tu.crossing.ui.wizard.CrySLFileUtil;
import de.darmstadt.tu.crossing.ui.wizard.CrySLTemplateFileInfo;
import de.darmstadt.tu.crossing.ui.wizard.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.ui.wizard.template.AbstractFileTemplate;
import org.eclipse.xtext.ui.wizard.template.AbstractTemplate;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.ui.wizard.template.IParameterPage;
import org.eclipse.xtext.ui.wizard.template.TemplateLabelProvider;

public class CrySLNewFileWizardPrimaryPage
extends WizardPage
implements IParameterPage {
    public static final String label_FileName = "File Name:";
    public static final String label_ClassName = "Class Name:";
    public static final String label_FolderName = "Source Folder:";
    private final AbstractFileTemplate[] templates;
    private final IStructuredSelection selection;
    private Text sourceFolder;
    private Text classText;
    private Text fileText;
    private CrySLComposite parameterComposite;
    private ComboViewer templateCombo;
    private TemplateLabelProvider labelProvider;

    protected CrySLNewFileWizardPrimaryPage(String pageName, AbstractFileTemplate[] templates, IStructuredSelection selection, TemplateLabelProvider labelProvider) {
        super(pageName);
        this.templates = templates;
        this.selection = selection;
        this.labelProvider = labelProvider;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.Control_Page_Title);
        if (this.hasExactlyOneTemplate()) {
            this.setDescription(this.getSelectedTemplate().getDescription());
        } else {
            this.setDescription(Messages.PrimaryPage_Description);
        }
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(2, false));
        this.createHeader(main);
        this.createTemplateWidgets(main);
        this.setControl((Control)main);
        this.validateInitial();
    }

    private void createHeader(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        main.setLayout((Layout)new GridLayout(3, false));
        Label projectLabel = new Label(main, 0);
        projectLabel.setText(label_FolderName);
        projectLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sourceFolder = new Text(main, 2052);
        this.sourceFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button projectBrowseButton = new Button(main, 8);
        projectBrowseButton.setText(org.eclipse.xtext.ui.wizard.template.Messages.NewFileWizardPrimaryPage_browse_button);
        projectBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label classLabel = new Label(main, 0);
        classLabel.setText(label_ClassName);
        classLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.classText = new Text(main, 2052);
        this.classText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.classText.setFocus();
        Label fileLabel = new Label(main, 0);
        fileLabel.setText(label_FileName);
        fileLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fileText = new Text(main, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fileText.setFocus();
        this.createNote(parent, true);
        if (this.getFolderFromSelection() != null) {
            this.sourceFolder.setText(this.getFolderFromSelection());
            if (!this.sourceFolder.getText().trim().isEmpty()) {
                this.getContentProposal();
            }
        }
        this.sourceFolder.addModifyListener(a -> this.validate());
        projectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrySLContainerSelectionDialog dialog = new CrySLContainerSelectionDialog(Display.getDefault().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, org.eclipse.xtext.ui.wizard.template.Messages.NewFileWizardPrimaryPage_selection_description);
                if (dialog.open() == 0) {
                    CrySLNewFileWizardPrimaryPage.this.sourceFolder.setText(CrySLNewFileWizardPrimaryPage.this.getFolderFromPath((IPath)dialog.getResult()[0]));
                    CrySLNewFileWizardPrimaryPage.this.getContentProposal();
                }
            }
        });
        this.classText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                CrySLNewFileWizardPrimaryPage.this.classText.setToolTipText(Messages.ClassName_ToolTip_Message);
            }

            public void focusLost(FocusEvent arg0) {
                CrySLNewFileWizardPrimaryPage.this.setFileName();
            }
        });
        this.sourceFolder.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                CrySLNewFileWizardPrimaryPage.this.sourceFolder.setToolTipText(Messages.Select_Project);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.fileText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                CrySLNewFileWizardPrimaryPage.this.fileText.setToolTipText(Messages.FileName_ToolTip_Message);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.fileText.setText(this.classText.getText());
        this.fileText.addModifyListener(e -> this.validate());
    }

    public String[] getClassses(Collection<String> classpath) {
        ArrayList<String> classes = new ArrayList<String>();
        for (String path : classpath) {
            if (ClassPathLoader.LoadClassListFromPath(path).isEmpty()) continue;
            classes.addAll(ClassPathLoader.LoadClassListFromPath(path));
        }
        if (!classes.isEmpty()) {
            String[] classArr = new String[classes.size()];
            classArr = classes.toArray(classArr);
            return classArr;
        }
        return null;
    }

    private String getFolderFromSelection() {
        Object element = this.selection.getFirstElement();
        IContainer container = null;
        if (element instanceof IContainer) {
            container = (IContainer)element;
        } else if (element instanceof IResource) {
            container = ((IResource)element).getParent();
        } else if (element instanceof IAdaptable) {
            IResource adapter = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            if (adapter instanceof IContainer) {
                container = (IContainer)adapter;
            } else if (adapter != null) {
                container = adapter.getParent();
            }
        }
        if (container != null) {
            return this.getFolderStringFromContainer(container);
        }
        return "";
    }

    private String getFolderStringFromContainer(IContainer container) {
        IProject project = container.getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IResource[] members;
                IResource[] iResourceArray = members = project.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IContainer) {
                        IContainer src = (IContainer)member;
                        if ("src".equals(member.getName())) {
                            return this.getFolderFromPath(src.getFullPath());
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getFolderFromPath(IPath path) {
        String result = path.toOSString();
        if (result.startsWith(File.separator)) {
            return result.substring(File.separator.length());
        }
        return result;
    }

    private void createTemplateWidgets(Composite main) {
        if (this.hasExactlyOneTemplateWithVariables()) {
            Label seperator = new Label(main, 258);
            seperator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.parameterComposite = new CrySLComposite(main, 0, (AbstractTemplate)this.templates[0], this);
            this.parameterComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        } else if (this.hasMoreThenOneTempalte()) {
            Label seperator = new Label(main, 258);
            seperator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Label templateLabel = new Label(main, 0);
            templateLabel.setText(org.eclipse.xtext.ui.wizard.template.Messages.NewFileWizardPrimaryPage_template_label);
            templateLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.templateCombo = new ComboViewer(main);
            this.templateCombo.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.templateCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.templateCombo.setInput((Object)this.templates);
            this.templateCombo.setSelection((ISelection)new StructuredSelection((Object)this.templates[0]));
            this.templateCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.templateCombo.getCombo().setToolTipText(this.getSelectedTemplate().getDescription());
            this.templateCombo.addSelectionChangedListener(e -> {
                this.templateCombo.getCombo().setToolTipText(this.getSelectedTemplate().getDescription());
                this.validate();
                this.getContainer().updateButtons();
            });
        }
    }

    private boolean hasExactlyOneTemplateWithVariables() {
        return this.hasExactlyOneTemplate() && this.templates[0].getVariables().size() > 0;
    }

    private boolean hasExactlyOneTemplate() {
        return this.templates.length == 1;
    }

    private boolean hasMoreThenOneTempalte() {
        return this.templates.length > 1;
    }

    private void validateInitial() {
        this.setStatus(null);
        IContainer projectContainer = this.getFolder(this.sourceFolder.getText());
        if (this.sourceFolder.getText().isEmpty()) {
            this.setStatus((IStatus)new Status(1, "NewFileWizard", Messages.Select_Directory));
            return;
        }
        if (projectContainer == null || !projectContainer.exists()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", Messages.Project_NotExixst));
            return;
        }
        if (this.parameterComposite != null) {
            this.parameterComposite.validate();
        }
        this.setPageComplete(false);
    }

    private void setFileName() {
        if (this.classText.getText().contains(".")) {
            String tempFileName = this.classText.getText().substring(this.classText.getText().lastIndexOf(".") + 1);
            String fileName = String.valueOf(tempFileName.substring(0, 1).toUpperCase()) + tempFileName.substring(1).toLowerCase();
            this.fileText.setText(fileName);
        }
    }

    private void validate() {
        if (this.fileText.getText().isEmpty()) {
            this.setFileName();
        }
        this.setStatus(null);
        IContainer projectContainer = this.getFolder(this.sourceFolder.getText());
        if (this.getSourceFolder().isEmpty()) {
            this.setStatus((IStatus)new Status(1, "NewFileWizard", Messages.Select_Project));
            return;
        }
        if (projectContainer == null || !projectContainer.exists()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", Messages.Project_NotExixst));
            return;
        }
        if (this.classText.getText().trim().isEmpty()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", Messages.ClassName_Empty));
            return;
        }
        if (this.fileText.getText().trim().isEmpty()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", Messages.FileName_Empty));
            return;
        }
        if (this.parameterComposite != null) {
            this.parameterComposite.validate();
        }
        if (this.getErrorMessage() == null && this.getSelectedTemplate() instanceof CrySLFile) {
            CrySLFile template = (CrySLFile)this.getSelectedTemplate();
            template.setTemplateInfo(this.getFileInfo());
            PathCollector fileCollector = new PathCollector();
            template.generateFiles(fileCollector);
            for (CharSequence path : fileCollector.getResult()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
                if (!file.exists()) continue;
                path = path.toString().replace("/", "\\");
                this.setStatus((IStatus)new Status(4, "NewFileWizard", String.valueOf(org.eclipse.xtext.ui.wizard.template.Messages.NewFileWizardPrimaryPage_file_already_exist_pre) + path + org.eclipse.xtext.ui.wizard.template.Messages.NewFileWizardPrimaryPage_file_already_exist_post));
                return;
            }
        }
    }

    public void setStatus(IStatus status) {
        if (status == null || status.getSeverity() == 0) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(true);
        } else if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 2);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 1);
            this.setPageComplete(true);
        }
    }

    private IContainer getFolder(String folderText) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path("/" + folderText));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(folderText);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public CrySLTemplateFileInfo getFileInfo() {
        return new CrySLTemplateFileInfo(this.getLocation(), this.getFileName(), this.getCryptoClassName(), this.getSelectedTemplate());
    }

    public String getLocation() {
        return this.sourceFolder.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getCryptoClassName() {
        String className = this.classText.getText();
        int index = className.lastIndexOf(".");
        if (className.contains(".")) {
            String temp = className.substring(0, index + 1);
            temp = String.valueOf(temp) + className.substring(index + 1, index + 2).toUpperCase();
            className = String.valueOf(temp) + className.substring(index + 2);
            className.toString().trim();
        }
        return className;
    }

    public AbstractFileTemplate getSelectedTemplate() {
        if (this.templates.length == 1) {
            return this.templates[0];
        }
        ISelection selection = this.templateCombo.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (AbstractFileTemplate)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void getContentProposal() {
        char[] autoActivationCharacters = new char[]{'.', ' '};
        try {
            String[] classes;
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            Collection<String> classpath = CrySLFileUtil.getProjectClassPath(this.sourceFolder.getText());
            if (!classpath.isEmpty() && (classes = this.getClassses(classpath)) != null) {
                SimpleContentProposalProvider contentProposalProvider = new SimpleContentProposalProvider(classes);
                contentProposalProvider.setFiltering(true);
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.classText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)contentProposalProvider, keyStroke, autoActivationCharacters);
                adapter.setPropagateKeys(true);
                adapter.setProposalAcceptanceStyle(2);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
    }

    private Group createNote(Composite parent, boolean visible) {
        Group notePanel = new Group(parent, 0);
        notePanel.setText("Note:");
        GridLayout gridLayout = new GridLayout();
        notePanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 1;
        notePanel.setLayoutData((Object)gridData);
        Font boldFont = new Font((Device)notePanel.getDisplay(), new FontData("Arial", 9, 1));
        notePanel.setFont(boldFont);
        notePanel.pack();
        this.setControl((Control)parent);
        StyledText note = new StyledText((Composite)notePanel, 66);
        note.setLayoutData((Object)new GridData(1808));
        String noteText = Messages.NoteText1;
        noteText = String.valueOf(noteText) + "\n" + Messages.NoteText2;
        note.setText(noteText);
        StyleRange style0 = new StyleRange();
        style0.metrics = new GlyphMetrics(0, 0, 40);
        style0.foreground = parent.getDisplay().getSystemColor(2);
        Bullet bullet0 = new Bullet(style0);
        note.setLineBullet(0, 2, bullet0);
        StyleRange style1 = new StyleRange();
        style1.start = 0;
        style1.length = 11;
        style1.font = boldFont;
        note.setStyleRange(style1);
        StyleRange style2 = new StyleRange();
        style2.start = 98;
        style2.length = 11;
        style2.font = boldFont;
        note.setStyleRange(style2);
        note.setLineBackground(0, 2, parent.getDisplay().getSystemColor(22));
        note.pack();
        note.setBounds(10, 20, 585, 60);
        note.setSize(note.computeSize(585, -1));
        this.setControl((Control)notePanel);
        note.setEditable(false);
        note.setEnabled(true);
        notePanel.setVisible(visible);
        return notePanel;
    }

    public String getSourceFolder() {
        return this.sourceFolder.getText();
    }

    private final class PathCollector
    implements IFileGenerator {
        private List<CharSequence> result = new ArrayList<CharSequence>();

        private PathCollector() {
        }

        public void generate(CharSequence path, CharSequence content) {
            this.result.add(path);
        }

        public List<CharSequence> getResult() {
            return this.result;
        }
    }
}

