/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import de.darmstadt.tu.crossing.ui.utils.ClassPathLoader;
import de.darmstadt.tu.crossing.ui.utils.ClassPathSolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class CrySLFileUtil {
    public static String createPath(String className) {
        int endIndex;
        String path = "";
        if (!className.isEmpty() && (endIndex = className.lastIndexOf(".")) != -1) {
            path = className.substring(0, endIndex);
        }
        path = path.replaceAll("\\.", "\\\\");
        return path;
    }

    public static String generateDirectory(String folderName, String className) {
        String relativePath = CrySLFileUtil.createPath(className);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile((IPath)new Path(folderName));
        IProject project = file.getProject();
        IPath path = file.getRawLocation();
        String absolutePath = String.valueOf(path.toString()) + System.getProperty("file.separator") + relativePath;
        java.nio.file.Path folderpath = Paths.get(absolutePath, new String[0]);
        if (!Files.exists(folderpath, new LinkOption[0])) {
            try {
                Files.createDirectories(folderpath, new FileAttribute[0]);
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException | CoreException e) {
                System.err.println("Fail to create directory: ' " + absolutePath + "' " + e);
            }
        }
        return absolutePath;
    }

    public static Collection<String> getProjectClassPath(String folderName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile((IPath)new Path(folderName));
        IProject project = file.getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject targetProject = JavaCore.create((IProject)project);
                Collection<String> classpath = ClassPathSolver.getClasspath(targetProject);
                return classpath;
            }
        }
        catch (CoreException e) {
            System.err.println("Fail to check projects Nature : ' " + project.getName() + "' " + (Object)((Object)e));
        }
        return null;
    }

    public static Class<?> getClass(String className, Collection<String> classpath) {
        for (String path : classpath) {
            Class<?> c = ClassPathLoader.LoadClassFromPath(className, path);
            if (c == null) continue;
            return c;
        }
        return null;
    }
}

