/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CrySLFileContentGenerator {
    private static List<String> abbrList;
    private Map<String, List<Method>> classMethods = new HashMap<String, List<Method>>();
    private Map<String, List<Constructor>> classConstructors = new HashMap<String, List<Constructor>>();
    private Map<Method, String> methodReturnMap = new HashMap<Method, String>();
    private Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();

    public CrySLFileContentGenerator() {
        abbrList = new ArrayList<String>();
        abbrList.add("alg");
        abbrList.add("mode");
        abbrList.add("pad");
        abbrList.add("in");
        abbrList.add("this");
        abbrList.add("length");
        abbrList.add("T");
        abbrList.add("E");
    }

    protected String generateContent(Class<?> c, String className) {
        String content = "SPEC " + className + "\n";
        if (c != null) {
            Method[] methods = c.getDeclaredMethods();
            if (methods.length > 0) {
                this.createMethodMap(methods);
                if (!this.classMethods.containsKey("getInstance")) {
                    Constructor[] constructors = c.getDeclaredConstructors();
                    this.createConstructorMap(constructors);
                }
                Map<Method, String> returnMap = this.createReturnMap(this.methodReturnMap);
                HashSet returnSet = new HashSet();
                returnMap.entrySet().forEach(entry -> returnSet.add((String)entry.getValue()));
                List<String> eventList = this.createEventList(this.classMethods, returnMap);
                if (this.classConstructors.size() > 0) {
                    eventList.addAll(this.createConstructorList(this.classConstructors));
                }
                List<String> objectList = this.createparamObj(this.parameterMap);
                content = String.valueOf(content) + "OBJECTS";
                for (String ret : returnSet) {
                    content = String.valueOf(content) + "\n\t" + ret + ";";
                }
                for (String obj : objectList) {
                    content = String.valueOf(content) + "\n\t" + obj + ";";
                }
                content = String.valueOf(content) + "\n\nEVENTS";
                for (String event : eventList) {
                    content = String.valueOf(content) + "\n\t" + event;
                }
                content = String.valueOf(content) + "\nORDER\n*";
                content = String.valueOf(content) + "\n\n//CONSTRAINTS//*";
                content = String.valueOf(content) + "\n\n//REQUIRES//*";
                content = String.valueOf(content) + "\n\n//ENSURES//*";
            }
        } else {
            content = String.valueOf(content) + "//'" + className + "' class is not found!";
            content = String.valueOf(content) + "\n\nOBJECTS\n*";
            content = String.valueOf(content) + "\n\nEVENTS\n*";
            content = String.valueOf(content) + "\n\nORDER\n*";
            content = String.valueOf(content) + "\n\n//CONSTRAINTS\n//*";
            content = String.valueOf(content) + "\n\n//REQUIRES\n//*";
            content = String.valueOf(content) + "\n\n//ENSURES\n//*";
        }
        return content;
    }

    private void createMethodMap(Method[] methods) {
        ArrayList<Method> parameterList = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !method.getName().contains("toString")) {
                if (!this.classMethods.containsKey(method.getName())) {
                    parameterList = new ArrayList();
                    parameterList.add(method);
                    this.classMethods.put(method.getName(), parameterList);
                } else {
                    parameterList.add(method);
                    this.classMethods.put(method.getName(), parameterList);
                }
                if (!method.getReturnType().getName().contains("void") && (method.getReturnType().getName().contains("String") || method.getReturnType().getName().contains("int") || method.getReturnType().getName().contains("byte") || method.getReturnType().getName().contains("long"))) {
                    this.methodReturnMap.put(method, method.getReturnType().getName());
                }
            }
            ++n2;
        }
    }

    private void createConstructorMap(Constructor[] constructors) {
        ArrayList<Constructor> constructorVarlist = new ArrayList<Constructor>();
        Constructor[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            if (!this.classConstructors.containsKey(constructor.getDeclaringClass().getSimpleName())) {
                constructorVarlist = new ArrayList();
                constructorVarlist.add(constructor);
                this.classConstructors.put(constructor.getDeclaringClass().getSimpleName(), constructorVarlist);
            } else {
                constructorVarlist.add(constructor);
                this.classConstructors.put(constructor.getDeclaringClass().getSimpleName(), constructorVarlist);
            }
            ++n2;
        }
    }

    private Map<Method, String> createReturnMap(Map<Method, String> methodReturnMap) {
        HashMap<Method, String> newMap = new HashMap<Method, String>();
        methodReturnMap.entrySet().forEach(entry -> {
            String returnObject = this.createRetrunObject(((Method)entry.getKey()).getName(), (String)entry.getValue());
            newMap.put((Method)entry.getKey(), returnObject);
        });
        return newMap;
    }

    private String createRetrunObject(String methodName, String returnType) {
        String objectName = String.valueOf(returnType) + " ";
        if (methodName.substring(0, 3).contains("get")) {
            methodName = methodName.substring(3, methodName.length());
            methodName = String.valueOf(methodName.toLowerCase().charAt(0)) + methodName.substring(1);
            objectName = String.valueOf(objectName) + methodName;
        } else {
            boolean hasUppercase;
            boolean bl = hasUppercase = !methodName.equals(methodName.toLowerCase());
            if (hasUppercase) {
                String abr = "";
                int i = 0;
                while (i < methodName.length() - 1) {
                    if (Character.isUpperCase(methodName.charAt(i))) {
                        abr = i == 0 ? String.valueOf(abr) + methodName.substring(i, Math.min(i + 3, methodName.length())).toLowerCase() : String.valueOf(abr) + methodName.substring(i, Math.min(i + 3, methodName.length()));
                    }
                    ++i;
                }
                Character.toLowerCase(methodName.charAt(0));
                objectName = String.valueOf(objectName) + methodName;
            } else {
                objectName = String.valueOf(objectName) + methodName.substring(0, Math.min(methodName.length(), 11));
            }
        }
        return objectName;
    }

    private List<String> createEventList(Map<String, List<Method>> classMethods, Map<Method, String> returnMap) {
        Iterator<Map.Entry<String, List<Method>>> it = classMethods.entrySet().iterator();
        ArrayList<String> eventList = new ArrayList<String>();
        Map<Object, Object> objectMap = new HashMap();
        String event = "";
        while (it.hasNext()) {
            Map.Entry<String, List<Method>> pair = it.next();
            String methodName = pair.getKey();
            List<Method> methods = pair.getValue();
            objectMap = this.createMethodParameterMap(methods);
            String abbr = this.genarateMethodAbbr(methodName);
            String group = "";
            if (methods.size() > 1) {
                if (methodName.substring(0, 3).equals("get")) {
                    group = String.valueOf(methodName.substring(3, methodName.length())) + "s := ";
                } else {
                    group = String.valueOf(methodName) + "s := ";
                    group = String.valueOf(group.substring(0, 1).toUpperCase()) + group.substring(1);
                }
                int i = 1;
                while (i <= methods.size()) {
                    group = String.valueOf(group) + abbr + i + "| ";
                    ++i;
                }
                group = String.valueOf(group.substring(0, group.length() - 2)) + ";\n";
            }
            int k = 1;
            for (Method m : methods) {
                String parameter;
                Parameter p;
                int n;
                int n2;
                Parameter[] parameterArray;
                Parameter[] params;
                String ret = "";
                if (returnMap.containsKey(m)) {
                    String retvalue = returnMap.get(m);
                    retvalue = retvalue.substring(retvalue.indexOf(" ") + 1, retvalue.length());
                    ret = String.valueOf(ret) + retvalue + " = ";
                }
                if (methods.size() <= 1) {
                    event = abbr;
                    params = m.getParameters();
                    if (params.length < 1) {
                        event = String.valueOf(event) + " : " + ret + methodName + "();";
                    } else {
                        event = String.valueOf(event) + " : " + ret + methodName + "(";
                        parameterArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            p = parameterArray[n];
                            parameter = String.valueOf((String)objectMap.get(p.toString())) + ", ";
                            event = String.valueOf(event) + parameter;
                            ++n;
                        }
                        event = String.valueOf(event.substring(0, event.length() - 2)) + ");";
                    }
                    eventList.add(event);
                    continue;
                }
                event = String.valueOf(abbr) + k;
                ++k;
                params = m.getParameters();
                if (params.length < 1) {
                    event = String.valueOf(event) + " : " + ret + methodName + "();";
                } else {
                    event = String.valueOf(event) + " : " + ret + methodName + "(";
                    parameterArray = params;
                    n2 = params.length;
                    n = 0;
                    while (n < n2) {
                        p = parameterArray[n];
                        parameter = String.valueOf((String)objectMap.get(p.toString())) + ", ";
                        event = String.valueOf(event) + parameter;
                        ++n;
                    }
                }
                event = String.valueOf(event.substring(0, event.length() - 2)) + ");";
                eventList.add(event);
            }
            eventList.add(group);
            it.remove();
        }
        return eventList;
    }

    private List<String> createConstructorList(Map<String, List<Constructor>> classConstructurs) {
        Iterator<Map.Entry<String, List<Constructor>>> it = classConstructurs.entrySet().iterator();
        ArrayList<String> eventList = new ArrayList<String>();
        Map<Object, Object> objectMap = new HashMap();
        String event = "";
        event = "";
        while (it.hasNext()) {
            Map.Entry<String, List<Constructor>> pair = it.next();
            String constName = pair.getKey();
            List<Constructor> constructors = pair.getValue();
            objectMap = this.createConstructorParameterMap(constructors);
            String abbr = this.genarateMethodAbbr(constName);
            String group = "";
            if (constructors.size() > 1) {
                group = String.valueOf(abbr) + "s := ";
                int i = 1;
                Iterator<Constructor> iterator = constructors.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    group = String.valueOf(group) + abbr + i + "| ";
                    ++i;
                }
                group = String.valueOf(group.substring(0, group.length() - 2)) + ";\n";
            }
            int k = 1;
            for (Constructor c : constructors) {
                String parameter;
                Parameter p;
                int n;
                int n2;
                Parameter[] parameterArray;
                Parameter[] params;
                if (constructors.size() <= 1) {
                    event = abbr;
                    params = c.getParameters();
                    if (params.length < 1) {
                        event = String.valueOf(event) + " : " + constName + "();";
                    } else {
                        event = String.valueOf(event) + " : " + constName + "(";
                        parameterArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            p = parameterArray[n];
                            parameter = String.valueOf((String)objectMap.get(p.toString())) + ", ";
                            event = String.valueOf(event) + parameter;
                            ++n;
                        }
                        event = String.valueOf(event.substring(0, event.length() - 2)) + ");";
                    }
                    eventList.add(event);
                    continue;
                }
                event = String.valueOf(abbr) + k;
                ++k;
                params = c.getParameters();
                if (params.length < 1) {
                    event = String.valueOf(event) + " : " + constName + "();";
                } else {
                    event = String.valueOf(event) + " : " + constName + "(";
                    parameterArray = params;
                    n2 = params.length;
                    n = 0;
                    while (n < n2) {
                        p = parameterArray[n];
                        parameter = String.valueOf((String)objectMap.get(p.toString())) + ", ";
                        event = String.valueOf(event) + parameter;
                        ++n;
                    }
                }
                event = String.valueOf(event.substring(0, event.length() - 2)) + ");";
                eventList.add(event);
            }
            eventList.add(group);
            it.remove();
        }
        return eventList;
    }

    private String genarateMethodAbbr(String methodName) {
        String abbr = "";
        Random r = new Random();
        if (methodName.contains("get")) {
            if (!abbrList.contains(abbr = String.valueOf(abbr) + Character.toLowerCase(methodName.charAt(3)))) {
                abbrList.add(abbr);
            } else {
                abbr = "";
                int i = 0;
                while (i < methodName.length() - 1) {
                    if (Character.isUpperCase(methodName.charAt(i))) {
                        abbr = String.valueOf(abbr) + methodName.substring(i, Math.min(i + 3, methodName.length()));
                    }
                    ++i;
                }
                if (!abbrList.contains(abbr = String.valueOf(Character.toLowerCase(abbr.charAt(0))) + abbr.substring(1))) {
                    abbrList.add(abbr);
                } else {
                    abbr = "";
                    String randomalph = methodName.replaceAll("[AEIOUaeiou]", "");
                    abbr = String.valueOf(abbr) + Character.toString(randomalph.charAt(r.nextInt(randomalph.length())));
                    abbr = String.valueOf(Character.toLowerCase(abbr.charAt(0))) + abbr.substring(1);
                    abbrList.add(abbr);
                }
            }
        } else {
            abbr = Character.toString(methodName.charAt(0)).toLowerCase();
            if (!abbrList.contains(abbr)) {
                abbrList.add(abbr);
            } else {
                boolean hasUppercase;
                boolean bl = hasUppercase = !methodName.equals(methodName.toLowerCase());
                if (hasUppercase) {
                    abbr = "";
                    int i = 0;
                    while (i < methodName.length() - 1) {
                        if (Character.isUpperCase(methodName.charAt(i))) {
                            if (Character.isUpperCase(methodName.charAt(i + 1))) {
                                abbr = String.valueOf(abbr) + methodName.substring(i, Math.min(i + 3, methodName.length()));
                                break;
                            }
                            abbr = String.valueOf(abbr) + methodName.substring(i, Math.min(i + 3, methodName.length()));
                        }
                        ++i;
                    }
                    abbr = String.valueOf(Character.toLowerCase(abbr.charAt(0))) + abbr.substring(1);
                    if (!abbrList.contains(abbr)) {
                        abbrList.add(abbr);
                    } else {
                        abbr = "";
                        String randomalph = methodName.replaceAll("[AEIOUaeiou]", "");
                        abbr = String.valueOf(abbr) + Character.toString(randomalph.charAt(r.nextInt(randomalph.length())));
                        abbr = String.valueOf(Character.toLowerCase(abbr.charAt(0))) + abbr.substring(1);
                        abbrList.add(abbr);
                    }
                }
            }
        }
        return abbr;
    }

    private List<String> createparamObj(Map<String, List<String>> objMap) {
        Iterator<Map.Entry<String, List<String>>> it = objMap.entrySet().iterator();
        ArrayList<String> objectList = new ArrayList<String>();
        List<Object> params = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> pair = it.next();
            params = pair.getValue();
            String objectType = pair.getKey();
            for (String string : params) {
                String obj = String.valueOf(objectType) + " " + string;
                objectList.add(obj);
            }
            it.remove();
        }
        return objectList;
    }

    private Map<String, String> createMethodParameterMap(List<Method> methodvariances) {
        HashMap<String, String> methodParameterMap = new HashMap<String, String>();
        HashSet<String> paramSet = new HashSet<String>();
        for (Method m : methodvariances) {
            Parameter[] params;
            Parameter[] parameterArray = params = m.getParameters();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                paramSet.add(p.toString());
                ++n2;
            }
        }
        for (String p : paramSet) {
            int size;
            String param = p.toString();
            String objectType = param.substring(0, param.lastIndexOf(" "));
            String parameter = this.createObject(p);
            List<Object> objectList = new ArrayList();
            if (this.parameterMap.containsKey(objectType)) {
                objectList = this.parameterMap.get(objectType);
                size = objectList.size() + 1;
                parameter = (String.valueOf(parameter) + size).toString();
                objectList.add(parameter);
                this.parameterMap.put(objectType, objectList);
            } else {
                size = 1;
                parameter = (String.valueOf(parameter) + size).toString();
                objectList.add(parameter);
                this.parameterMap.put(objectType, objectList);
            }
            if (methodParameterMap.containsKey(p)) continue;
            methodParameterMap.put(p, parameter);
        }
        return methodParameterMap;
    }

    private Map<String, String> createConstructorParameterMap(List<Constructor> constructorVariances) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        HashSet<String> paramSet = new HashSet<String>();
        for (Constructor c : constructorVariances) {
            Parameter[] params;
            Parameter[] parameterArray = params = c.getParameters();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                paramSet.add(p.toString());
                ++n2;
            }
        }
        for (String p : paramSet) {
            int size;
            String param = p.toString();
            String objectType = param.substring(0, param.lastIndexOf(" "));
            String parameter = this.createObject(p);
            List<Object> objectList = new ArrayList();
            if (this.parameterMap.containsKey(objectType)) {
                objectList = this.parameterMap.get(objectType);
                size = objectList.size() + 1;
                parameter = (String.valueOf(parameter) + size).toString();
                objectList.add(parameter);
                this.parameterMap.put(objectType, objectList);
            } else {
                size = 1;
                parameter = (String.valueOf(parameter) + size).toString();
                objectList.add(parameter);
                this.parameterMap.put(objectType, objectList);
            }
            if (parameterMap.containsKey(p)) continue;
            parameterMap.put(p, parameter);
        }
        return parameterMap;
    }

    private String createObject(String p) {
        String objectName;
        String objectType = p.substring(0, p.lastIndexOf(" "));
        int index = objectType.lastIndexOf(".");
        if (index > 0) {
            objectName = objectType.substring(index + 1);
            if (objectName.length() <= 9) {
                objectName = objectName.toLowerCase();
            } else {
                boolean hasUppercase;
                boolean bl = hasUppercase = !objectName.equals(objectName.toLowerCase());
                if (hasUppercase) {
                    String abr = "";
                    int i = 0;
                    while (i < objectName.length() - 1) {
                        if (Character.isUpperCase(objectName.charAt(i))) {
                            abr = i == 0 ? String.valueOf(abr) + objectName.substring(i, Math.min(i + 3, objectName.length())).toLowerCase() : String.valueOf(abr) + objectName.substring(i, Math.min(i + 3, objectName.length()));
                        }
                        ++i;
                    }
                    objectName = abr;
                } else {
                    objectName = objectName.substring(0, Math.min(objectName.length(), 11));
                }
            }
        } else {
            boolean hasUppercase = !objectType.equals(objectType.toLowerCase());
            objectName = !hasUppercase && objectType.matches("[a-zA-Z]+") && objectType.length() < 5 ? objectType : String.valueOf(objectType.substring(0, 2)) + objectType.substring(2, objectType.length()).replaceAll("[AEIOUaeiou]", "");
        }
        if (objectType.contains("[")) {
            objectName = String.valueOf(objectName) + "Array";
        } else if (objectType.contains("Map")) {
            objectName = String.valueOf(objectName) + "Map";
        } else if (objectType.contains("List")) {
            objectName = String.valueOf(objectName) + "List";
        } else if (objectType.contains("Set")) {
            objectName = String.valueOf(objectName) + "Set";
        }
        return objectName.replaceAll("[^a-zA-Z]", "");
    }
}

