/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import de.darmstadt.tu.crossing.ui.wizard.CrySLFileContentGenerator;
import de.darmstadt.tu.crossing.ui.wizard.CrySLFileUtil;
import de.darmstadt.tu.crossing.ui.wizard.CrySLTemplateFileInfo;
import java.util.Collection;
import org.eclipse.xtext.ui.wizard.template.AbstractFileTemplate;
import org.eclipse.xtext.ui.wizard.template.FileTemplate;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.ui.wizard.template.TemplateFileInfo;
import org.eclipse.xtext.ui.wizard.template.WorkspaceFileGenerator;

@FileTemplate(label="CrySL File wizard", icon="cognicrypt.png", description="Create a file with CrySL File Wizard")
public final class CrySLFile
extends AbstractFileTemplate {
    private CrySLTemplateFileInfo info;
    private String javaClassName;
    private CrySLFileContentGenerator fileContentGenerator;

    public void generateFiles(IFileGenerator generator) {
        String content = "";
        this.javaClassName = this.getCryptoClassName().replaceAll("\\s", "");
        String folderDir = String.valueOf(this.getFolder()) + System.getProperty("file.separator") + CrySLFileUtil.createPath(this.javaClassName);
        if (generator instanceof WorkspaceFileGenerator) {
            this.fileContentGenerator = new CrySLFileContentGenerator();
            try {
                Class<?> claz = Class.forName(this.javaClassName);
                content = this.fileContentGenerator.generateContent(claz, this.javaClassName);
                CrySLFileUtil.generateDirectory(this.getFolder(), this.javaClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Collection<String> classpath = CrySLFileUtil.getProjectClassPath(this.getFolder());
                Class<?> claz = CrySLFileUtil.getClass(this.javaClassName, classpath);
                content = this.fileContentGenerator.generateContent(claz, this.javaClassName);
                CrySLFileUtil.generateDirectory(this.getFolder(), this.javaClassName);
            }
        }
        generator.generate((CharSequence)(String.valueOf(folderDir) + "/" + this.getName() + ".crysl"), (CharSequence)content);
    }

    void setTemplateInfo(CrySLTemplateFileInfo info) {
        this.info = info;
    }

    protected TemplateFileInfo getTemplateInfo() {
        return this.info;
    }

    protected String getFolder() {
        return this.info.getFolder();
    }

    protected String getName() {
        if (this.info.getName().endsWith(".crysl")) {
            return this.info.getName().replace(".crysl", "");
        }
        return this.info.getName();
    }

    protected String getCryptoClassName() {
        return this.info.getCryptoClassName();
    }
}

