/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.wizard;

import de.darmstadt.tu.crossing.ui.wizard.CrySLDrillDownComposite;
import de.darmstadt.tu.crossing.ui.wizard.CrySLTreeViewer;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CrySLContainerSelectionGroup
extends ContainerSelectionGroup {
    private boolean showClosedProjects = true;
    private IStructuredSelection selection;
    CrySLTreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public CrySLContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects) {
        super(parent, listener, allowNewContainerName, message, showClosedProjects);
        this.showClosedProjects = showClosedProjects;
    }

    public void setSelectedContainer(IContainer container) {
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }

    protected void createTreeViewer(int heightHint) {
        CrySLDrillDownComposite drillDown = new CrySLDrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData(spec);
        this.treeViewer = new CrySLTreeViewer(drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(this.showClosedProjects);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(event -> {
            this.selection = event.getStructuredSelection();
            this.containerSelectionChanged((IContainer)this.selection.getFirstElement());
        });
        this.treeViewer.addDoubleClickListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (item == null) {
                    return;
                }
                if (this.treeViewer.getExpandedState(item)) {
                    this.treeViewer.collapseToLevel(item, 1);
                } else {
                    this.treeViewer.expandToLevel(item, 1);
                }
            }
        });
        this.treeViewer.setInput(ResourcesPlugin.getWorkspace());
    }

    public IFolder getSelectedFolder() {
        if (this.selection.getFirstElement() instanceof IFolder) {
            IFolder ifolder = (IFolder)this.selection.getFirstElement();
            return ifolder;
        }
        return null;
    }
}

