/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClassPathSolver {
    public static Collection<String> getClasspath(IJavaProject javaProject) {
        Collection<String> libraryClassPath = ClassPathSolver.libraryClassPath(javaProject);
        return libraryClassPath;
    }

    private static Collection<String> applicationClassPath(IJavaProject javaProject) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            ArrayList<String> urls = new ArrayList<String>();
            URI uriString = workspace.getRoot().getFile(javaProject.getOutputLocation()).getLocationURI();
            urls.add(new File(uriString).getAbsolutePath());
            return urls;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private static Collection<String> libraryClassPath(IJavaProject project) {
        HashSet libraryClassPath = Sets.newHashSet();
        try {
            IClasspathEntry[] rentries;
            IClasspathEntry[] iClasspathEntryArray = rentries = project.getRawClasspath();
            int n = rentries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                ClassPathSolver.resolveClassPathEntry(entry, libraryClassPath, project);
                ++n2;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return libraryClassPath;
    }

    private static void resolveClassPathEntry(IClasspathEntry entry, Collection<String> libraryClassPath, IJavaProject project) {
        switch (entry.getEntryKind()) {
            case 3: {
                libraryClassPath.addAll(ClassPathSolver.applicationClassPath(project));
                break;
            }
            case 2: {
                IJavaProject requiredProject = JavaCore.create((IProject)((IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath())));
                try {
                    IClasspathEntry[] rentries;
                    IClasspathEntry[] iClasspathEntryArray = rentries = project.getRawClasspath();
                    int n = rentries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry e = iClasspathEntryArray[n2];
                        ClassPathSolver.resolveClassPathEntry(e, libraryClassPath, requiredProject);
                        ++n2;
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 1: {
                IPath path = entry.getPath();
                if (!path.toString().contains(".m2/repository")) break;
                libraryClassPath.add(path.toString());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                try {
                    IClasspathEntry[] subEntries;
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] iClasspathEntryArray = subEntries = container.getClasspathEntries();
                    int n = subEntries.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IClasspathEntry subEntry = iClasspathEntryArray[n3];
                        ClassPathSolver.resolveClassPathEntry(subEntry, libraryClassPath, project);
                        ++n3;
                    }
                    break;
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

