/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathLoader {
    public static Class<?> LoadClassFromPath(String keyClassName, String path) {
        URL url = null;
        File file = new File(path);
        try {
            url = file.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            if (file.isDirectory()) {
                List<Object> classList = new ArrayList();
                classList = ClassPathLoader.createFileList(path);
                for (File file2 : classList) {
                    if (file2.isDirectory() || !file2.getName().endsWith(".class")) continue;
                    String absolutePath = file2.getAbsoluteFile().getPath();
                    int indexof = absolutePath.indexOf(path) + path.length() + 1;
                    String className = absolutePath.substring(indexof);
                    if (!(className = className.replace(System.getProperty("file.separator"), ".").substring(0, className.length() - 6).split("\\$")[0]).equals(keyClassName)) continue;
                    Class<?> c = loader.loadClass(className);
                    return c;
                }
            } else {
                JarFile jar = new JarFile(path);
                boolean bl = false;
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements() && !bl) {
                    String className;
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || !(className = je.getName().replace('/', '.').substring(0, je.getName().length() - 6).split("\\$")[0]).equals(keyClassName)) continue;
                    boolean bl2 = true;
                    Class<?> c = loader.loadClass(className);
                    return c;
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println(String.valueOf(keyClassName) + " class not found in projects classpath. " + e);
        }
        catch (IOException e1) {
            System.err.println("Error reading class from path: '" + path + "' " + e1);
        }
        return null;
    }

    public static List<String> LoadClassListFromPath(String path) {
        File file = new File(path);
        ArrayList<String> classes = new ArrayList<String>();
        URL url = null;
        try {
            url = file.toURI().toURL();
            new URLClassLoader(new URL[]{url});
            if (file.isDirectory()) {
                List<File> classList = ClassPathLoader.createFileList(path);
                if (!classList.isEmpty()) {
                    for (File f : classList) {
                        if (f.isDirectory() || !f.getName().endsWith(".class")) continue;
                        String absolutePath = f.getAbsoluteFile().getPath();
                        int indexof = absolutePath.indexOf(path) + path.length() + 1;
                        String className = absolutePath.substring(indexof);
                        if (classes.contains(className = className.replace(System.getProperty("file.separator"), ".").substring(0, className.length() - 6).split("\\$")[0])) continue;
                        classes.add(className);
                    }
                }
            } else {
                JarFile jar = new JarFile(path);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    String classname;
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || classes.contains(classname = je.getName().replace('/', '.').substring(0, je.getName().length() - 6).split("\\$")[0])) continue;
                    classes.add(classname);
                }
            }
        }
        catch (IOException e1) {
            System.err.println("Error loading classes from path: '" + path + "' " + e1);
        }
        return classes;
    }

    public static List<File> createFileList(String path) {
        ArrayList<File> fileList = new ArrayList<File>();
        ClassPathLoader.getFileListFromDirectory(path, fileList);
        return fileList;
    }

    public static void getFileListFromDirectory(String directoryName, List<File> files) {
        File directory = new File(directoryName);
        File[] fList = directory.listFiles();
        if (fList != null) {
            File[] fileArray = fList;
            int n = fList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    files.add(file);
                } else if (file.isDirectory()) {
                    ClassPathLoader.getFileListFromDirectory(file.getAbsolutePath(), files);
                }
                ++n2;
            }
        }
    }
}

