/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.ui.contentassist;

import com.google.inject.Inject;
import de.darmstadt.tu.crossing.services.CrySLGrammarAccess;
import de.darmstadt.tu.crossing.ui.contentassist.AbstractCrySLProposalProvider;
import de.darmstadt.tu.crossing.ui.utils.ClassPathLoader;
import de.darmstadt.tu.crossing.ui.utils.ClassPathSolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CrySLSprayProposalProvider
extends AbstractCrySLProposalProvider {
    @Inject
    CrySLGrammarAccess grammarAccess;
    private static Keyword keyword;

    @Override
    public void completeMethod_MethName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String className = this.getSelectedClassName(context);
        keyword = this.grammarAccess.getAggregateAccess().getSemicolonKeyword_1_3();
        try {
            Class<?> c = Class.forName(className);
            this.addMethodstoProposal(c, context, acceptor);
        }
        catch (ClassNotFoundException e) {
            Collection<String> classpath = this.getProjectClassPath(context);
            if (classpath != null) {
                Class<?> c = this.getClassMethods(className, classpath);
                this.addMethodstoProposal(c, context, acceptor);
            }
            System.err.println(String.valueOf(className) + " class not found" + e);
        }
    }

    @Override
    public void completeAggregate_Lab(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        keyword = this.grammarAccess.getAggregateAccess().getSemicolonKeyword_1_3();
        context.getRootNode().getChildren().forEach(item -> {
            if ("EVENTS".equals(item.getText())) {
                item.getNextSibling().getLeafNodes().forEach(item2 -> {
                    String itemText = item2.getText();
                    if (":".equals(itemText) || ":=".equals(itemText)) {
                        String text = null;
                        while (item2.getPreviousSibling().getText().trim().isEmpty()) {
                            text = item2.getPreviousSibling().getText();
                            item2 = (ILeafNode)item2.getPreviousSibling();
                        }
                        text = item2.getPreviousSibling().getText();
                        this.completeproposal(text, context, acceptor);
                    }
                });
            }
        });
    }

    @Override
    public void completeAggregateExpression_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode currNode = context.getCurrentNode();
        if (currNode.hasPreviousSibling() && currNode.getPreviousSibling().hasPreviousSibling() && "CONSTRAINTS".equals(currNode.getPreviousSibling().getPreviousSibling().getText())) {
            this.completeAggregateProposal(context, acceptor);
        } else {
            super.completeAggregateExpression_Value(model, assignment, context, acceptor);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode currNode = context.getCurrentNode();
        if (currNode.hasPreviousSibling() && currNode.getPreviousSibling().hasPreviousSibling() && "CONSTRAINTS".equals(currNode.getPreviousSibling().getPreviousSibling().getText())) {
            String prevNodeText = currNode.getPreviousSibling().getText();
            if (prevNodeText.length() <= 0 || prevNodeText.charAt(prevNodeText.length() - 1) == ';') {
                this.completeAggregateProposal(context, acceptor);
                this.completeConstraintProposal(context, acceptor);
            } else {
                super.completeKeyword(keyword, context, acceptor);
            }
        } else {
            super.completeKeyword(keyword, context, acceptor);
        }
    }

    public void completeConstraintProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Keyword predicate = this.grammarAccess.getPreDefinedPredicatesAccess().getPredNameCallToKeyword_2_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getPreDefinedPredicatesAccess().getPredNameLengthKeyword_4_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getPreDefinedPredicatesAccess().getPredNameNeverTypeOfKeyword_0_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getPreDefinedPredicatesAccess().getPredNameNoCallToKeyword_1_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getPreDefinedPredicatesAccess().getPredNameNotHardCodedKeyword_3_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getConsPredAccess().getConsPredAlgKeyword_0_0_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getConsPredAccess().getConsPredModeKeyword_0_1_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getConsPredAccess().getConsPredPadKeyword_0_2_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getConsPredAccess().getPartPartKeyword_1_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
        predicate = this.grammarAccess.getArrayElementsAccess().getElElementsKeyword_0_0_0();
        this.completeproposal(predicate.getValue(), context, acceptor);
    }

    public void completeproposal(String word, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal proposal = this.createCompletionProposal(word, word, this.getImage((EObject)keyword), contentAssistContext);
        this.getPriorityHelper().adjustKeywordPriority(proposal, contentAssistContext.getPrefix());
        acceptor.accept(proposal);
    }

    public void completeAggregateProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        context.getRootNode().getChildren().forEach(item -> {
            if ("OBJECTS".equals(item.getText())) {
                item.getNextSibling().getLeafNodes().forEach(item2 -> {
                    if (";".equals(item2.getText())) {
                        String text = null;
                        text = item2.getPreviousSibling().getText().substring(1);
                        this.completeproposal(text, context, acceptor);
                    }
                });
            }
        });
    }

    public String getSelectedClassName(ContentAssistContext context) {
        String classname = null;
        BidiIterable childrens = context.getRootNode().getChildren();
        for (INode children : childrens) {
            if (!"SPEC".equals(children.getText())) continue;
            classname = children.getNextSibling().getText().replaceAll("\\s+", "");
        }
        return classname;
    }

    public Collection<String> getProjectClassPath(ContentAssistContext context) {
        URI uri = context.getRootModel().eResource().getURI();
        if (uri.isPlatform()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return ClassPathSolver.getClasspath(JavaCore.create((IProject)project));
                }
            }
            catch (CoreException e) {
                System.err.println((Object)e);
            }
        }
        return null;
    }

    public Class<?> getClassMethods(String classname, Collection<String> classpath) {
        for (String path : classpath) {
            Class<?> c = ClassPathLoader.LoadClassFromPath(classname, path);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public void addMethodstoProposal(Class<?> claz, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Constructor<?>[] constructors;
        Method[] methods;
        ArrayList<String> methodList = new ArrayList<String>();
        Method[] methodArray = methods = claz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !methodList.contains(method.getName())) {
                methodList.add(String.valueOf(method.getName()) + "()");
                this.completeproposal(String.valueOf(method.getName()) + "()", context, acceptor);
            }
            ++n2;
        }
        Constructor<?>[] constructorArray = constructors = claz.getDeclaredConstructors();
        int n3 = constructors.length;
        n = 0;
        while (n < n3) {
            Constructor<?> constructor = constructorArray[n];
            this.completeproposal(String.valueOf(constructor.getName().substring(constructor.getName().lastIndexOf(".") + 1)) + "()", context, acceptor);
            ++n;
        }
    }
}

